<?php
session_start();
include 'conexao.php';

if (!isset($_SESSION['aluno'])) {
    header("Location: login_aluno.php");
    exit;
}

// Pega o ID do aluno logado
$aluno_id = $_SESSION['aluno']['id'];

// Obtém o filtro de mês e ano da URL
$mes_filtro = $_GET['mes'] ?? '';
$ano_filtro = $_GET['ano'] ?? date('Y'); // Assume o ano atual se não houver filtro

// Consulta somente os dados do aluno logado, usando as colunas corretas
$sql = "SELECT p.id AS id_pagamento, a.nome AS aluno, p.mes, p.ano, p.valor_pago, p.data_pagamento
        FROM alunos a
        LEFT JOIN propinas p ON a.id = p.aluno_id
        WHERE a.id = ?";

// Adiciona o filtro de mês e ano, se existirem
if ($mes_filtro) {
    $sql .= " AND p.mes = ?";
}
$sql .= " AND p.ano = ?";

// Prepara e executa a consulta com base nos filtros
if ($mes_filtro) {
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("isi", $aluno_id, $mes_filtro, $ano_filtro);
} else {
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $aluno_id, $ano_filtro);
}

$stmt->execute();
$res = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Histórico de Pagamentos</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #f4f6f9;
            margin: 0;
            padding: 20px;
        }
        h2 {
            text-align: center;
            color: #003366;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ccc;
            padding: 8px;
            text-align: left;
            font-size: 14px;
        }
        th {
            background: #003366;
            color: white;
        }
        select {
            padding: 5px;
        }
        .btn-recibo {
            padding: 5px 10px;
            background: #003366;
            color: white;
            border: none;
            border-radius: 4px;
            text-decoration: none;
            font-size: 13px;
        }
        .btn-recibo:hover {
            background: #00509e;
        }
    </style>
</head>
<body>

<a href="painel_aluno.php" style="
    display: inline-block;
    margin: 20px;
    padding: 10px 20px;
    background-color: #003366;
    color: white;
    text-decoration: none;
    border-radius: 5px;
    font-weight: bold;
">
    ⬅ Voltar ao Painel
</a>

<h2>Histórico de Pagamento de Propinas</h2>

<form method="get" style="margin-bottom: 20px; text-align: center;">
    <label for="mes">Filtrar por Mês:</label>
    <select name="mes" id="mes" onchange="this.form.submit()">
        <option value="">Todos os meses</option>
        <?php
        $meses = ['Janeiro','Fevereiro','Março','Abril','Maio','Junho',
                  'Julho','Agosto','Setembro','Outubro','Novembro','Dezembro'];
        foreach ($meses as $mes) {
            $selected = $mes === $mes_filtro ? "selected" : "";
            echo "<option value=\"$mes\" $selected>$mes</option>";
        }
        ?>
    </select>
</form>

<table>
    <tr>
        <th style="width: 30%;">Nome do Aluno</th>
        <th style="width: 15%;">Mês</th>
        <th style="width: 10%;">Ano</th>
        <th style="width: 15%;">Valor</th>
        <th style="width: 20%;">Data</th>
        <th style="width: 10%;">Recibo</th>
    </tr>
    <?php if ($res && $res->num_rows > 0): ?>
        <?php while ($row = $res->fetch_assoc()): ?>
            <tr>
                <td><?= htmlspecialchars($row['aluno']) ?></td>
                <td><?= $row['mes'] ?? '<span style="color:red;">Não Pago</span>' ?></td>
                <td><?= $row['ano'] ?? '-' ?></td>
                <td><?= $row['valor_pago'] ? number_format($row['valor_pago'], 2, ',', '.') . " Kz" : '-' ?></td>
                <td><?= $row['data_pagamento'] ? date("d/m/Y", strtotime($row['data_pagamento'])) : '-' ?></td>
                <td>
                    <?php if (!empty($row['id_pagamento'])): ?>
                        <a class="btn-recibo" href="recibo_propina.php?id=<?= $row['id_pagamento'] ?>" target="_blank">Ver Recibo</a>
                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>
            </tr>
        <?php endwhile; ?>
    <?php else: ?>
        <tr><td colspan="6" style="text-align:center;">Nenhum registro encontrado.</td></tr>
    <?php endif; ?>
</table>

</body>
</html>